﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace GcWebCopyScript
{
    class Program
    {
        static void Main(string[] args)
        {
            // path sorgente e destinazione della cartella immagini
            string source = @"INSERITE QUA IL PATH SORGENTE DELLA CARTELLA CONTENENTE LE LOCANDINE";
            string target = @"INSERITE QUA IL PATH DESTINAZIONE DELLA CARTELLA CONTENETE LE LOCANDINE";
            DirectoryInfo diSource = new DirectoryInfo(source);
            DirectoryInfo diTarget = new DirectoryInfo(target);

            CopyAll(diSource, diTarget);

            // path sorgente e destinazione del file .gcs
            string gcsSource = @"PATH SORGENTE FILE .GCS";
            string gcsTarget = @"PATH DESTINAZIONE FILE .GCS";
            FileInfo fiGcsSource = new FileInfo(gcsSource);
            FileInfo fiGcsTarget = new FileInfo(gcsTarget);

            OverwriteFile(fiGcsSource, fiGcsTarget);

        }

        public static void CopyAll(DirectoryInfo source, DirectoryInfo target)
        {
            if (source.FullName.ToLower() == target.FullName.ToLower())
            {
                return;
            }

            // Check if the target directory exists, if not, create it.
            if (Directory.Exists(target.FullName) == false)
            {
                Directory.CreateDirectory(target.FullName);
            }

            // Copy each file into it's new directory.
            foreach (FileInfo fi in source.GetFiles())
            {
                // Controllo se il file esiste già
                if (File.Exists(target.FullName + "/" + fi.Name) == false)
                {
                    //Console.WriteLine(@"Copying {0}\{1}", target.FullName, fi.Name);
                    fi.CopyTo(Path.Combine(target.ToString(), fi.Name), true);
                }
                //else
                    //Console.WriteLine(target.FullName + "/" + fi.Name + " esiste già");
                    
            }

            // Copy each subdirectory using recursion.
            foreach (DirectoryInfo diSourceSubDir in source.GetDirectories())
            {
                DirectoryInfo nextTargetSubDir =
                    target.CreateSubdirectory(diSourceSubDir.Name);
                CopyAll(diSourceSubDir, nextTargetSubDir);
            }
        }

        public static void OverwriteFile(FileInfo source, FileInfo target)
        {
            // Controllo se source e target sono lo stesso path
            if ((source.FullName).ToLower() == (target.FullName).ToLower())
                return;

            // Se il file non esiste lo creo
            if (File.Exists(target.FullName) == false)
            {
                File.Create(target.FullName);
                //Console.WriteLine("Creato il file " + target.FullName);
            }

            // Sovrascrivo il file
            source.CopyTo(target.FullName, true);
            //Console.WriteLine(source.FullName + " -> " + target.FullName);
        }

    }
}
