'/*
' * This script first starts services for VMWARE, then starts VMWARE Workstation.
' *	Once VMWARE stops, services are stopped and terminated again.
' * Prerequisites for this script:
' * Modify: Computer Management -> Services -> VMware USB Arbitration Service ->Startup Type:Manual
' * Modify: Computer Management -> Services -> VMware Nat Service ->Startup Type:Manual
' * Modify: Computer Management -> Services -> VMware DHCP Service ->Startup Type:Manual
' * Modify: Computer Management -> Services -> VMware Authorization Service ->Startup Type:Manual
' * Remove HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run\VMware hqtray
' * Remove HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run\vmware-tray
' * Modify: Disable VMware Network Adapter VMnet1 network interface
' * Modify: Disable VMware Network Adapter VMnet8 network interface
' * 
' * written 080821 by w_m0zart / Marc Nijdam. http://www.nijdam.de/marc.html
' * modified by Angaran Stefano http://blog.upyou.it
' * modified by Andrea Giacomin http://www.badalis.it
' */

'/*
' * Main
' */
'Set FSO = CreateObject("Scripting.FileSystemObject")
'Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
Set objRegistry = GetObject("winmgmts:\\.\root\default:StdRegProv")
Set shell = Wscript.CreateObject("Wscript.shell") 

dim naptime
naptime = 18
shell.Popup "VMWare si avvier tra poco", naptime, "Avviando VMWare", 0

dim pth
dim pgm1
dim pgm2
dim pgm3
dim cmnd
dim qq

qq = Chr(34) ' define quote as constant, because shell.run does not accept a program without this function

' Program to start with command line options
pth = "C:\Program Files (x86)\VMware\VMware Workstation\"
pgm1 = "vmware.exe"
pgm2 = "hqtray.exe"
pgm3 = "vmware-tray.exe"
cmnd = ""
rem Now starting services
startService ("VMAuthdService")
startService ("VMnetDHCP")
startService ("VMware NAT Service")
startService ("VMUSBArbService")
enableNetInt ("VMware Virtual Ethernet Adapter for VMnet1")
enableNetInt ("VMware Virtual Ethernet Adapter for VMnet8")

shell.run qq & pth & pgm2 & qq,0,false
shell.run qq & pth & pgm3 & qq,0,false

shell.run qq & pth & pgm1 & qq & cmnd,1,true ' now starting vmware.exe

'shell.Popup "VMWare si chiuder tra poco", naptime, "Terminando VMWare", 0
rem Now stopping services
stopService ("VMAuthdService")
stopService ("VMware NAT Service")
stopService ("VMnetDHCP")
stopService ("VMUSBArbService")
killProcess ("hqtray.exe") ' service which cannot be stopped with the function stopservice (...)
killProcess ("vmware-tray.exe") ' service which cannot be stopped with the function stopservice (...)
disableNetInt ("VMware Virtual Ethernet Adapter for VMnet1")
disableNetInt ("VMware Virtual Ethernet Adapter for VMnet8")


rem Removing registry key
If objRegistry.EnumValues (HKLM, "SOFTWARE\Microsoft\Windows\CurrentVersion\Run\vmware-tray", arrValueNames, arrValueTypes) = 0 Then
    shell.RegDelete( "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run\vmware-tray") ' Remove this particular key again from the registry, since vmware wrote this back
End If

'/*
' * Start a service with its service name in the Windows Services (via Computer Management)
' */
function startService(serviceName)
	Dim objShell
	Dim bReturn

	Set objShell = CreateObject("Shell.Application")

	bReturn = objShell.ServiceStart(serviceName, false)

	Set objShell = nothing
End function

'/*
' * Stop a service with its service name in the Windows Services (via Computer Management)
' */
function stopService(serviceName)
	Dim objShell
	Dim bReturn

	Set objShell = CreateObject("Shell.Application")

	bReturn = objShell.ServiceStop(serviceName, false)

	Set objShell = nothing
End function

'/*
' * Enable a network interface
' */
sub enableNetInt(interfaceName)
	Dim colItems, objItem
	Set colItems = GetObject("Winmgmts:").ExecQuery("SELECT * FROM Win32_NetworkAdapter WHERE Name ='" & interfaceName & "'")
	For Each objItem in colItems 
		objItem.Enable()
	Next
End sub

'/*
' * Disable a network interface
' */
sub disableNetInt(interfaceName)
	Dim colItems, objItem
	Set colItems = GetObject("Winmgmts:").ExecQuery("SELECT * FROM Win32_NetworkAdapter WHERE Name ='" & interfaceName & "'")
	For Each objItem in colItems 
		objItem.Disable()
	Next
End sub

'/*
' * Kill a process with name StrProcess corresponding in the Windows Task Manager
' */
Sub killProcess (processName) 
	Dim colProcessList, objProcess
	Set colProcessList = GetObject("Winmgmts:").ExecQuery("Select * from Win32_Process WHERE Name ='" & processName & "'")
	For Each objProcess in colProcessList
    		objProcess.Terminate()
	Next
End sub